//								EJEMPLO 26
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El TMR2. Temporizacin simple, segundero
//
//El TMR2 provoca una interrupcin cada 10 mS. Transcurridas 100 interrupciones, el tiempo total
//transcurrido es de 1 segundo.
//
//Los leds conectados a la puerta B visualizan, en binario, el segundero


#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)

int	delay=100;		//Variable para temporizacin

#int_timer2		//Vector de interrupcin del timer 2
tratamiento()	//Funcin de tratamiento del timer 2
{ 
	if (delay == 0)	//Se han producido 10 interrupciones ??
	 {	output_b (input_b()+1);	//Si, incremetar puerta A 
		delay=100;	//Reponer variable de temporizacin
	}
	else 
		-- delay;	//Decrementa variable de temporizacin
}
	
main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);//Puerta A Digital
	output_b(0x00);		//Borra salidas
	set_tris_b(0x00);	//Puerta B salida	
	enable_interrupts(int_timer2); //Activa interrupcin del TMR2

//El TMR2 emplea un preescaler y un postcaler de 1:16 (total 1:256). Trabajando a una
//frecuencia de 4MHZ el TMR2 evoluciona cada 16uS (preescaler 1:16). La cuenta avanza hasta
//alcanzar el valor del registro de periodos (39), con lo que el tiempo transcurrido es de
//624 uS. Este lapsus se repite 16 veces (postcaler 1:16) antes de provocar la interrupcin
//(al de 9984 uS).

	setup_timer_2(t2_div_by_16,39,16);	//TMR2 pre y postcaler 1:16, periodo 39
	set_timer2(0x00);	//Inicia el TMR2
	enable_interrupts(global);	//Habilita interrupciones

	while(1)
	{	
	}
}	
